unit DT1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, FileCtrl, UnZIP;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Image1: TImage;
    Image2: TImage;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Dclarations prives }
    procedure SetPath(Value:string);
    procedure WMErase(Var Msg:TWMEraseBkGnd); message wm_erasebkgnd;
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type
  TBrowseInfo = packed record
    hwndOwner: HWND;
    pidlRoot: THandle;
    pszDisplayName: PAnsiChar; { Return display name of item selected. }
    lpszTitle: PAnsiChar; { text to go in the banner over the tree. }
    ulFlags: UINT; { Flags that control the return stuff }
    lpfn: pointer;
    lParam: LPARAM; { extra info that's passed back in callbacks }
    iImage: Integer; { output var: where to return the Image index. }
  end;

function SHBrowseForFolder(var bi: TBrowseInfo): THandle; stdcall; external
  'shell32.dll' name 'SHBrowseForFolderA';

function SHGetPathFromIDList(id: THandle; Path: PChar): bool; stdcall; external
  'shell32.dll' name 'SHGetPathFromIDListA';

function MakeDir(dir:string):boolean;
 begin
  Result:=DirectoryExists(dir);
  if not Result then
   if MessageBox(
    0,pchar('Voulez-vous crer le rpertoire ' + dir + ' ?'), 'DelphTools V1.0',
    MB_YESNO + MB_DEFBUTTON1 + MB_APPLMODAL + MB_ICONQUESTION
   )=IDYES then
    Result:=ForceDirectories(Dir);
 end;

procedure TForm1.WMErase(Var Msg:TWMEraseBkGnd);
 var
  Canvas:TCanvas;
  Ht:integer;
  Row:integer;
 begin
  Canvas := TCanvas.Create;
  Canvas.Handle := Msg.DC;
  Ht := (250 + 400) div 256;
  for Row := 0 to 255 do
   with Canvas do begin
    Brush.Color := RGB(0, (row div 2) - 100, 255 - row);
    FillRect(Rect(0, (Row * Ht), 400, (Row + 1) * Ht));
   end;
  Canvas.Free;
 end;

procedure TForm1.Button1Click(Sender: TObject);
var
 bi:TBrowseInfo;
 id:THandle;
 nm:array[0..MAX_PATH] of Char;
begin
 FillChar(bi, sizeof(bi), 0);
 bi.hwndOwner := Handle;
 bi.lpszTitle := 'Extraire les fichiers vers...';
 id := SHBrowseForFolder(bi);
 if id<>0 then begin
  SHGetPathFromIDList(id, nm);
  SetPath(nm);
 end;
end;

procedure TForm1.SetPath(Value:string);
 begin
  if (Value<>'') and (Value[Length(Value)] <> '\') then Value:=Value+'\';
  if pos('Delphtools', Value) = 0 then Value := Value + 'Delphtools\';
  if MakeDir(Value) then Edit1.Text:=Value;
 end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 MessageBox(0, 'Une autre fois peut-tre', 'DelphTools', 0);
 Application.Terminate;
end;

{$R monres.RES}

procedure TForm1.Button2Click(Sender: TObject);
var
 s:string;
 RES:TResourceStream;
begin
 s:=Edit1.Text;
 if (s<>'')and(s[length(s)]<>'\') then s:=s+'\';
 if MakeDir(s) then begin
  RES := TResourceStream.Create(hInstance, 'MonZip', 'EXEFILE');
  try
 //dcompresse les fichiers contenus dans le Zip
  if UnZipAll(RES, s) = 6 then begin
   MessageBox(0, 'Installation termine', 'DelphTools', 0);
   Application.Terminate;
  end else begin
   MessageBox(0, 'Erreur inattendue', 'TinyUnZip', 0);
  end;
  finally
   RES.Free;
  end;
 end;
end;

end.
