program DelphTools;

{cet exemple montre comment crer un programme d'installation en utilisant les API
un grand merci  Toth Paul http://tothpaul.free.fr pour son aide, oh combien prcieuse

Pour une question ou un commentaire, passez me voir sur
 http://perso.wanadoo.fr/fobec/delphi_index.htm
}

uses
  windows, messages, UnZIP, classes, graphics, sysutils;
{$R DelphTools.RES}
{$R instal.RES}
{$R monres.RES}

type
  TBrowseInfo = packed record
    hwndOwner: HWND;
    pidlRoot: THandle;
    pszDisplayName: PAnsiChar; { Return display name of item selected. }
    lpszTitle: PAnsiChar; { text to go in the banner over the tree. }
    ulFlags: UINT; { Flags that control the return stuff }
    lpfn: pointer;
    lParam: LPARAM; { extra info that's passed back in callbacks }
    iImage: Integer; { output var: where to return the Image index. }
  end;

function SHBrowseForFolder(var bi: TBrowseInfo): THandle; stdcall; external
  'shell32.dll' name 'SHBrowseForFolderA';

function SHGetPathFromIDList(id: THandle; Path: PChar): bool; stdcall; external
  'shell32.dll' name 'SHGetPathFromIDListA';
//vrifie que le rpertoire existe
function DirectoryExists(const Name: string): Boolean;
var
  Code: Integer;
begin
  Code := GetFileAttributes(PChar(Name));
  Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

//crer un rpertoire
procedure ForceDirectories(Dir: string);
begin
  if (AnsiLastChar(Dir) <> nil) and (AnsiLastChar(Dir)^ = '\') then
    Delete(Dir, Length(Dir), 1);
  if (Length(Dir) < 3) or DirectoryExists(Dir)
    or (ExtractFilePath(Dir) = Dir) then Exit;
  ForceDirectories(ExtractFilePath(Dir));
  CreateDir(Dir);
end;

//vrifie si le rpertoire d'installation existe
function verifie_rep(path: string; hwnd: hwnd): boolean;
begin
  result := false;
  if (Path <> '') and (Path[Length(Path)] <> '\') then
    Path := Path + '\';
  if pos('Delphtools', path) = 0 then
    path := path + 'Delphtools\';
  if not directoryexists(path) then
  begin
    if MessageBox(0, pchar('Voulez-vous crer le rpertoire ' + path
      + ' ?'), 'DelphTools V1.0',
      MB_YESNO + MB_DEFBUTTON1 + MB_APPLMODAL + MB_ICONQUESTION) =
      IDYES then
    begin
      ForceDirectories(PChar(path));
      if directoryexists(path) then
        result := SetWindowText(GetDlgItem(HWnd, 5), pchar(path))
      else
        result := false;
    end;
  end
  else
    result := SetWindowText(GetDlgItem(HWnd, 5), pchar(path));
end;

var
  RES: TResourceStream;
  ZIP: TZIPRec;
  bibi: Tbitmap;
  bi: TBrowseInfo;
  id: THandle;
  nm: array[0..MAX_PATH] of Char;
  Path: string;

//gre certains messages de la boite de dialogue
function dialog(HWnd, Msg, wParam, lParam: integer): integer; stdcall;
var
  Canvas: TCanvas;
  Ima: hbitmap;
  rep: array[0..255] of char;
  rep2: string;
  Row, Ht: Word;
  texte1, texte2: string;

begin
  Result := 1;
  case Msg of
    //dessine les images lors de l'initialisation
    WM_INITDIALOG:
      begin
        Ima := LoadBitmap(hInstance, 'Monbmp');
        SendDlgItemMessage(HWnd, 15, STM_SETIMAGE, IMAGE_BITMAP, Ima);

        Ima := LoadBitmap(hInstance, 'Bmp2');
        SendDlgItemMessage(HWnd, 16, STM_SETIMAGE, IMAGE_BITMAP, Ima);
      end;

    //lorsque windows efface l'arrire plan, on crer le dgrad
    WM_ERASEBKGND:
      begin
        Canvas := TCanvas.Create;
        Canvas.Handle := wParam;
        Ht := (250 + 400) div 256;
        for Row := 0 to 255 do
          with Canvas do
          begin
            Brush.Color := RGB(0, (row div 2) - 100, 255 - row);
            FillRect(Rect(0, (Row * Ht),
              400, (Row + 1) * Ht));
          end;

        Canvas.Free;
        //Affiche du texte sur la fentre
        SetBkMode(wParam, TRANSPARENT);
        texte1 := 'Voici un exemple de programme d''installation';
        Texte2 := 'FOBEC@wanadoo.fr ';
        textout(wParam, 50, 90, pchar(texte1), length(texte1));
        textout(wParam, 70, 110, pchar(texte2), length(texte2));

        SetTextColor(wParam, clwhite);
        texte1 := 'Un grand merci  Toth Paul pour son aide';
        Texte2 := 'http://tothpaul.free.fr';
        textout(wParam, 50, 130, pchar(texte1), length(texte1));
        textout(wParam, 70, 150, pchar(texte2), length(texte2));

        SetTextColor(wParam, clred);
        texte1 := 'Rpertoire d''installation';
        textout(wParam, 10, 180, pchar(texte1), length(texte1));
      end;

    //interprte les commandes
    WM_COMMAND:
      case wParam of
        1:
          begin
            FillChar(bi, sizeof(bi), 0);
            bi.hwndOwner := HWnd;
            bi.lpszTitle := 'Extraire les fichiers vers...';
            id := SHBrowseForFolder(bi);
            if id <> 0 then
            begin
              SHGetPathFromIDList(id, nm);
              Path := nm;
              if not verifie_rep(path, hwnd) then
                result := 0;
            end;
          end;
        2: EndDialog(HWnd, 2); // Exit
        3:
          begin
            GetWindowText(GetDlgItem(HWnd, 5), rep, 255);
            rep2 := rep;
            if verifie_rep(rep2, hwnd) = true then
            begin
              if rep2[length(rep2)] <> '\' then
                rep2 := rep2 + '\';
              //dcompresse les fichiers contenus dans le Zip
              if UnZipAll(RES, rep2) = 6 then
                EndDialog(HWnd, 1)
              else
                EndDialog(HWnd, -1);
            end
            else
              result := 0;
          end;
      else
        Result := 0;
      end;
  else
    Result := 0;
  end;
end;

begin
  //extrait le fichier Zip
  RES := TResourceStream.Create(hInstance, 'MonZip', 'EXEFILE');
  try
    //crer la boite de dialogue
    case DialogBox(hInstance, 'INSTAL', 0, @Dialog) of
      -1: MessageBox(0, 'Erreur de DialogBox', 'DelphTools', 0);
      1: MessageBox(0, 'Installation termine', 'DelphTools', 0);
      2: MessageBox(0, 'Une autre fois peut-tre', 'DelphTools', 0);
    else
      MessageBox(0, 'Erreur inattendue', 'TinyUnZip', 0);
    end;
  finally
    RES.Free;
  end;
end.

