Unit Classes;

Interface

Uses
 Windows,SysUtils,Dialogs;

Type
 TNotifyEvent=procedure(Sender:TObject) of object;

 TPointers=array[word] of pointer;
 PPointers=^TPointers;

 TList=class
 private
  fList:PPointers;
  fCount:integer;
  fSize :integer;
  function GetItem(index:integer):pointer;
  procedure SetItem(index:integer; value:pointer);
 public
  Destructor Destroy; override;
  function Add(Item:pointer):integer;
  procedure Clear;
  property Count:integer read fCount;
  property Item[index:integer]:pointer read GetItem write SetItem; default;
 end;

 TStringItem=record
  Str:string;
  Obj:TObject;
 end;
 TStringItems=array[word] of TStringItem;
 PStringItems=^TStringItems;

 TStringList=class
 private
  fList:PStringItems;
  fCount:integer;
  fSize :integer;
  function GetItem(index:integer):string;
  procedure SetItem(index:integer; value:string);
  function GetObject(index:integer):TObject;
  procedure SetObject(index:integer; value:TObject);
 public
  Destructor Destroy; override;
  function Add(s:string):integer;
  function AddObject(s:string;AObject:TObject):integer;
  procedure Clear;
  property Count:integer read fCount;
  property Strings[index:integer]:string read GetItem write SetItem; default;
  property Objects[index:integer]:TObject read GetObject write SetObject;
 end;

{ minimal Stream implementation for UnZIP.PAS }
const { TFileStream create mode }
  fmCreate = $FFFF;

Type  
 TStream=class
 protected
  fSize:integer;
  procedure SetPosition(value:integer); virtual; abstract;
  function GetPosition:integer; virtual; abstract;
 public
  function Read(var Buffer; Count: Longint): Longint; virtual; abstract;
  procedure ReadBuffer(var Buffer; Count: Longint);
  function Write(var Buffer; Count: Longint): Longint; virtual; abstract;
  property Size:integer read fSize;
  property Position:integer read GetPosition write SetPosition;
 end;

 TFileStream=class(TStream)
 private
  fHandle:integer; // file handle
 protected
  procedure SetPosition(value:integer); override;
  function GetPosition:integer; override;
 public
  constructor Create(const FileName: string; Mode: Word);
  destructor Destroy; override;
  function Read(var Buffer; count:longint):longint; override;
  function Write(var Buffer; Count: Longint): Longint; override;
 end;

 TResourceStream=class(TStream)
 private
  fHandle:HGlobal;
  fPointer:Pchar;
  fPosition:integer;
 protected
  procedure SetPosition(value:integer); override;
  function GetPosition:integer; override;
 public
  constructor Create(Instance: THandle; const ResName: string; ResType: PChar);
  destructor Destroy; override;
  function Read(var Buffer; count:longint):longint; override;
 end;

 TFilerFlag = (ffInherited, ffChildPos, ffInline);
 TFilerFlags = set of TFilerFlag;

 TValueType = (vaNull, vaList, vaInt8, vaInt16, vaInt32, vaExtended,
    vaString, vaIdent, vaFalse, vaTrue, vaBinary, vaSet, vaLString,
    vaNil, vaCollection, vaSingle, vaCurrency, vaDate, vaWString, vaInt64);

 TComponent=class;

 TReader=class
 private
  fHandle:HGlobal;
  fStart:integer;
  fPointer:pointer;
  fSize:integer;
  fPosition:integer;
  fChilds:TList;
  procedure SetPosition(Value:integer);
 public
  Constructor Create(ResourceName:string);
  Destructor Destroy; override;
  procedure Loading(AComponent:TComponent);
  Function Read(Var Data;DataSize:integer):integer;
  Function EndOfList:boolean;
  Function ReadValueType:TValueType;
  Function BooleanProperty:boolean;
  Function IntegerProperty:integer;
  Function StringProperty:string;
  Function ColorProperty:integer;
  Function BinaryProperty(Var Size:integer):pointer;
  Procedure IdentProperty(Var Value; Const Names:array of PChar);
  Procedure SetProperty(Var ASet;Const Names:array of PChar);
  Function ReadByte:byte;
  Function ReadWord:word;
  Function ReadInteger:integer;
  Function ReadString:string;
  procedure ReadPrefix(var Flags: TFilerFlags; var AChildPos: Integer);
  property Size:integer read fSize;
  property Position:integer read fPosition write SetPosition;
 end;

 TPersistent=class
 protected
  function SubProperty(Name:string):TPersistent; virtual; abstract;
  procedure ReadProperty(Name:string; Reader:TReader); virtual;
 end;

 TPersistentClass=class of TPersistent;

 TComponent=class(TPersistent)
 private
  fOwner :TComponent;
 protected
  fName :string;
  procedure SetParentComponent(Value:TComponent); virtual;
  function GetParentComponent:TComponent; virtual;
 public
  property ParentComponent:TComponent read GetParentComponent write SetParentComponent;
  Constructor Create(AOwner:TComponent); virtual;
  procedure ReadProperties(Reader:TReader);
  procedure Loaded; virtual;
  property Owner:TComponent read fOwner;
 end;

 TComponentClass=class of TComponent;

Procedure RegisterClasses(AClasses: array of TPersistentClass);
//Procedure OverrideClasses(AClasses: array of TPersistentClass);

Implementation

Destructor TList.Destroy;
 begin
  Clear;
  inherited;
 end;

function TList.GetItem(index:integer):pointer;
 begin
  Result:=fList[Index];
 end;

procedure TList.SetItem(index:integer; value:pointer);
 begin
  fList[Index]:=Value;
 end;

function TList.Add(Item:pointer):integer;
 begin
  if fCount=fSize then begin
   if fSize>64 then inc(fSize,fSize div 4) else
   if fSize>8  then inc(fSize,16) else inc(fSize,4);
   ReallocMem(fList,fSize*SizeOf(pointer))
  end;
  fList[fCount]:=Item;
  Result:=fCount;
  inc(fCount);
 end;

procedure TList.Clear;
 begin
  fCount:=0;
  fSize :=0;
  ReallocMem(fList,0);
 end;

Destructor TStringList.Destroy;
 begin
  clear;
  inherited;
 end;

function TStringList.GetItem(index:integer):string;
 begin
  result:=fList[index].str;
 end;

procedure TStringList.SetItem(index:integer; value:string);
 begin
  fList[index].str:=value;
 end;

function TStringList.GetObject(index:integer):TObject;
 begin
  result:=fList[index].obj;
 end;

procedure TStringList.SetObject(index:integer; value:TObject);
 begin
  fList[index].obj:=value;
 end;

function TStringList.Add(s:string):integer;
 begin
  Result:=AddObject(s,nil);
 end;

function TStringList.AddObject(s:string;AObject:TObject):integer;
 begin
  if fCount=fSize then begin
   if fSize>64 then inc(fSize,fSize div 4) else
   if fSize>8  then inc(fSize,16) else inc(fSize,4);
   ReallocMem(fList,fSize*SizeOf(TStringItem))
  end;
  fList[fCount].str:=s;
  fList[fCount].obj:=AObject;
  Result:=fCount;
  inc(fCount);
 end;

procedure TStringList.Clear;
 begin
  fCount:=0;
  fSize:=0;
  ReallocMem(fList,0);
 end;

Type
 PRegisteredClass=^TRegisteredClass;
 TRegisteredClass=record
  RClass:TPersistentClass;
  Next  :PRegisteredClass;
 end;

var
 RegisteredClasses:PRegisteredClass=nil;

Procedure RegisterClasses(AClasses: array of TPersistentClass);
 var
  i:integer;
  RC:PRegisteredClass;
 begin
  for i:=Low(AClasses) to High(AClasses) do begin
   new(RC);
   RC.RClass:=AClasses[i];
   RC.Next:=RegisteredClasses;
   RegisteredClasses:=RC;
  end;
 end;
{
Procedure OverrideClasses(AClasses: array of TPersistentClass);
 var
  i:integer;
  RC:PRegisteredClass;
 begin
  for i:=Low(AClasses) to High(AClasses) do begin
   RC:=RegisteredClasses;
   While (RC<>nil)and(RC.RClass.ClassName<>AClasses[i].ClassName) do RC:=RC.Next;
   if RC=nil then begin
    WriteLn(AClasses[i].ClassName,' wasn''t registered.');
    new(RC);
    RC.Next:=RegisteredClasses;
    RegisteredClasses:=RC;
   end;
   RC.RClass:=AClasses[i];
  end;
 end;
}
Function CreateComponent(AClass:string; AOwner:TComponent):TComponent;
 var
  RC:PRegisteredClass;
 begin
  RC:=RegisteredClasses;
  while (RC<>nil)and(RC.RClass.ClassName<>AClass) do RC:=RC.Next;
  if RC=nil then begin
   Result:=nil;
   Error(AClass+' not registered')
  end else begin
   Result:=(RC.RClass.NewInstance as TComponent);
   Result.Create(AOwner);
  end;
 end;

Procedure TStream.ReadBuffer(var Buffer; Count: Longint);
 begin
  Read(Buffer,Count);
 end;

Constructor TFileStream.Create(const FileName: string; Mode: Word);
 begin
  if (Mode and fmCreate)<>0 then
   fHandle:=FileCreate(FileName)
  else
   fHandle:=FileOpen(FileName,Mode);
  fSize:=FileSeek(fHandle,0,2);
  Position:=0;
 end;

Destructor TFileStream.Destroy;
 begin
  FileClose(fHandle);
  inherited;
 end;

Procedure TFileStream.SetPosition(Value:integer);
 begin
  FileSeek(fHandle,Value,0);
 end;

Function TFileStream.GetPosition:integer;
 begin
  Result:=FileSeek(fHandle,0,1); // from current
 end;

Function TFileStream.Read(var Buffer; Count: Longint):longint;
 begin
  Result:=FileRead(fHandle,Buffer,Count);
 end;

Function TFileStream.Write(var Buffer; Count: Longint): Longint;
 begin
  Result:=FileWrite(fHandle,Buffer,Count);
 end;

constructor TResourceStream.Create(Instance: THandle; const ResName: string; ResType: PChar);
 var
  res:THandle;
 begin
  res:=FindResource(Instance,PChar(ResName),ResType);
  if res=0 then exit;
  fHandle:=LoadResource(Instance,res);
  if fHandle=0 then exit;
  fPointer:=LockResource(fHandle);
  if fPointer<>nil then fSize:=SizeOfResource(Instance,res);
 end;

Destructor TResourceStream.Destroy;
 begin
  UnlockResource(fHandle);
  FreeResource(fHandle);
  inherited;
 end;

Procedure TResourceStream.SetPosition(Value:integer);
 begin
  fPosition:=Value;
 end;

Function TResourceStream.GetPosition:integer;
 begin
  Result:=fPosition;
 end;

Function TResourceStream.Read(var Buffer; Count: Longint):integer;
 begin
  Result:=count;
  if fPosition+Result>fSize then Result:=fSize-fPosition;
  move(fPointer[fPosition],Buffer,Result);
  Inc(fPosition,Result);
 end;

Constructor TReader.Create(ResourceName:string);
 var
  res:THandle;
 begin
  res:=FindResource(hInstance,PChar(ResourceName),RT_RCDATA);
  if res=0 then exit;
  fHandle:=LoadResource(hInstance,res);
  if fHandle=0 then exit;
  fPointer:=LockResource(fHandle);
  if fPointer<>nil then fSize:=SizeOfResource(hInstance,res);
  fStart:=integer(fPointer);
  fChilds:=TList.Create;
 end;

Destructor TReader.Destroy;
 var
  i:integer;
 begin
  UnlockResource(fHandle);
  FreeResource(fHandle);
  for i:=0 to fChilds.Count-1 do TComponent(fChilds[i]).Loaded;
  fChilds.Free;
  inherited;
 end;

Procedure TReader.SetPosition(Value:integer);
 begin
  fPosition:=Value;
  fPointer:=Pointer(fStart+Value);
 end;

Procedure TReader.Loading(AComponent:TComponent);
 begin
  fChilds.Add(AComponent);
 end;

Function TReader.Read(Var Data; DataSize:integer):integer;
 begin
  if fPosition+DataSize<fSize then Result:=DataSize else Result:=fSize-fPosition;
  if Result>0 then begin
   move(fPointer^,Data,Result);
   Inc(fPosition,Result);
   Inc(integer(fPointer),Result);
  end;
 end;

Function TReader.EndOfList:boolean;
 begin
  Result:=(fPosition<fSize)and(byte(fPointer^)=0);
  if Result then begin
   inc(fPosition);
   inc(integer(fPointer));
  end;
 end;

Function TReader.ReadValueType:TValueType;
 begin
  Read(Result,SizeOf(Result));
 end;

Function TReader.BooleanProperty:boolean;
 var
  ValueType:TValueType;
 begin
  ValueType:=ReadValueType;
  case ValueType of
   vaFalse  : Result:=False;
   vaTrue   : Result:=True;
   else Error('Invalide boolean value '+inttostr(ord(ValueType)));
  end;
 end;

Function TReader.IntegerProperty:integer;
 var
  ValueType:TValueType;
 begin
  ValueType:=ReadValueType;
  case ValueType of
   vaInt8  : Result:=ShortInt(ReadByte);
   vaInt16 : Result:=ReadWord;
   vaInt32 : Result:=ReadInteger;
   else Error('Invalide ordinal value '+inttostr(ord(ValueType)));
  end;
 end;

Function TReader.StringProperty:string;
 var
  ValueType:TValueType;
 begin
  ValueType:=ReadValueType;
  case ValueType of
   vaString,
   vaIdent :Result:=ReadString;
   else Error('Invalide string value '+inttostr(ord(ValueType)));
  end;
 end;

Function TReader.ColorProperty:integer;
 var
  ValueType:TValueType;
 begin
  ValueType:=ReadValueType;
  case ValueType of
   vaInt32 : Result:=ReadInteger;
   vaIdent : Result:=IdentToColor(ReadString);
   else Error('Invalide color value '+inttostr(ord(ValueType)));
  end;
 end;

Function TReader.BinaryProperty(Var Size:integer):pointer;
 var
  ValueType:TValueType;
 begin
  ValueType:=ReadValueType;
  case ValueType of
   vaBinary : begin
    Size:=ReadInteger;
    GetMem(Result,Size);
    Read(Result^,Size);
   end;
   else Error('Invalide binary value '+inttostr(ord(ValueType)));
  end;
 end;

Procedure TReader.IdentProperty(var Value; Const Names:array of PChar);
 var
  ValueType:TValueType;
 begin
  ValueType:=ReadValueType;
  case ValueType of
   vaIdent : integer(Value):=StringIndex(ReadString,Names);
   else Error('Invalide ident value '+inttostr(ord(ValueType)));
  end;
 end;

Procedure TReader.SetProperty(Var ASet;Const Names:array of PChar);
 var
  s:string;
  i:integer;
  v:integer;
 begin
  if ReadValueType<>vaSet then error('not a set');
  v:=0;
  repeat
   s:=ReadString;
   i:=StringIndex(s,Names);
   if i>=0 then v:=v or (1 shl i);
  until s='';
  integer(ASet):=v;
 end;

Function TReader.ReadByte:byte;
 begin
  Read(Result,SizeOf(Result));
 end;

Function TReader.ReadWord:word;
 begin
  Read(Result,SizeOf(Result));
 end;

Function TReader.ReadInteger:integer;
 begin
  Read(Result,SizeOf(Result));
 end;

Function TReader.ReadString:string;
 begin
  SetLength(Result,ReadByte);
  Read(Result[1],Length(Result));
 end;

procedure TReader.ReadPrefix(var Flags: TFilerFlags; var AChildPos: Integer);
 begin
  Flags := [];
  if (fSize>1) and (Byte(fPointer^) and $F0 = $F0) then begin
   Byte(Flags):=ReadByte and $0F;
   if ffChildPos in Flags then AChildPos:=ReadInteger;
  end;
end;

procedure TPersistent.ReadProperty(Name:string; Reader:TReader);
 var
  ValueType:TValueType;
  Value:string;
  i:integer;
 begin
  i:=pos('.',Name);
  if i>0 then begin
   Value:=Copy(Name,1,i-1);
   Delete(Name,1,i);
//  {$ifdef debug}writeln(ClassName,'.',Value);{$endif}
   SubProperty(Value).ReadProperty(Name,Reader);
  end else begin
   ValueType:=Reader.ReadValueType;
   case ValueType of
   {
    vaNull,
    vaList, }
    vaInt8   : Value:=IntToStr(Reader.ReadByte);
    vaInt16  : Value:=IntToStr(Reader.ReadWord);
  {  vaInt32,
    vaExtended,  }
    vaString : Value:=Reader.ReadString;
    vaIdent  : Value:='"'+Reader.ReadString+'"';
    vaFalse  : Value:='"FALSE"';
    vaTrue   : Value:='"TRUE"';
    vaBinary : begin
                i:=Reader.ReadInteger; Value:='('+IntToStr(i)+' bytes)';
                //Reader.Position:=Reader.Position+i
                while i>0 do begin Reader.ReadByte; dec(i) end;
               end;
{    vaSet,
    vaLString,
    vaNil,
    vaCollection,
    vaSingle,
    vaCurrency,
    vaDate,
    vaWString,
    vaInt64:;
   }
    else Error('Unknow value type '+IntToStr(ord(ValueType)));
   end;
   {$ifdef debug}writeln(Name+'='+Value);{$endif}
  end;
 end;

Constructor TComponent.Create(AOwner:TComponent);
 begin
  fOwner:=AOwner;
 end;

procedure TComponent.ReadProperties(Reader:TReader);
 var
  Flags:TFilerFlags;
  position:integer;
  child:TComponent;
  field:^TComponent;
 begin
  while not Reader.EndOfList do ReadProperty(Reader.ReadString,Reader);
  while not Reader.EndOfList do begin
   Reader.ReadPrefix(Flags,Position);
   Child:=CreateComponent(Reader.ReadString,Self); // ClassName name
   Child.SetParentComponent(Self);
   Reader.Loading(Child);
   Child.fName:=Reader.ReadString; // Component Name
   Child.ReadProperties(Reader);
   field:=FieldAddress(Child.fName);
   if field<>nil then begin
    field^:=Child;
//    {$ifdef debug}writeln('@Child=',IntToHex(integer(@Child),4));{$endif}
   end;
  end;
 end;

procedure TComponent.Loaded;
 begin
//  msgbox(fName+' loaded');
 end;


procedure TComponent.SetParentComponent(Value:TComponent);
 begin
 end;

function TComponent.GetParentComponent:TComponent;
 begin
  result:=fOwner;
 end;

{$ifdef debug}
initialization
 allocconsole;
{$endif}
end.

