Unit ExtCtrls;

Interface

uses
 Sysutils,Classes,Controls,Graphics;

Type
 TImage=class(TGraphicControl)
 private
  fPicture:TPicture;
  Function GetPicture:TPicture;
 protected
  Function SubProperty(Name:string):TPersistent; override;
 public
  Destructor Destroy; override;
  procedure paint; override;
  Property Picture:TPicture read GetPicture;
 end;

Implementation

Destructor TImage.Destroy;
 begin
  fPicture.Free;
 end;

Function TImage.GetPicture:TPicture;
 begin
  if fPicture=nil then fPicture:=TPicture.Create;
  Result:=fPicture;
 end;

Function TImage.SubProperty(Name:string):TPersistent;
 Const
  TPictureSubProperties:array[0..0] of PChar=(
   'Picture'
  );
 begin
  case StringIndex(Name,TPictureSubProperties) of
   0 : Result:=Picture;
   else Result:=Inherited SubProperty(Name);
  end;
 end;

Procedure TImage.Paint;
 begin
  if fPicture=nil then
   Inherited
  else
   fPicture.DrawRect(ClientRect,Canvas); // not VCL standard, but it work for BITMAP.
 end;

Initialization
 RegisterClasses([TImage]);

end.
