Unit FileCtrl;

Interface

uses
 windows,sysutils;

// Borland's code
function DirectoryExists(const Name: string): Boolean;
function ForceDirectories(Dir: string): Boolean;

Implementation

function DirectoryExists(const Name: string): Boolean;
var
  Code: Integer;
begin
  Code := GetFileAttributes(PChar(Name));
  Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

function ForceDirectories(Dir: string): Boolean;
begin
  Result := True;
  if (Dir<>'')and(Dir[Length(Dir)]='\') then SetLength(Dir,Length(Dir)-1);
  if (Length(Dir) < 3) or DirectoryExists(Dir)
    or (ExtractFilePath(Dir) = Dir) then Exit; // avoid 'xyz:\' problem.
  Result := ForceDirectories(ExtractFilePath(Dir)) and CreateDir(Dir);
end;

end.
