Unit Forms;
{$define CLX} { clx define some additionnal properties }
Interface

uses
{$ifdef linux}
 Xlib,Libc,
{$endif}
 Windows,Messages,Classes,SysUtils,Graphics,Controls,StdCtrls;

Type
 TFormBorderStyle = (bsNone, bsSingle, bsSizeable, bsDialog, bsToolWindow, bsSizeToolWin);

 TCustomForm=class(TWinControl)
 private
 {$ifdef clx}
  fHorzScrollBar:TScrollBar;
  fVertScrollBar:TScrollBar;
 {$endif}
 // unusefull properties...
  fPixelsPerInch:integer;
  fTextHeight:integer;
  fOldCreateOrder:boolean;
  fBorderStyle:TFormBorderStyle;
 protected
  procedure Load;
  procedure Read(Reader:TReader);
 {$ifdef clx}
  Function SubProperty(Name:string):TPersistent; override;
 {$endif}
  procedure ReadProperty(Name:string; Reader:TReader); override;
  procedure CreateHandle; override;
 public
  Constructor Create(AOwner:TComponent); override;
  Destructor Destroy; override;
 end;

{$M+}
 TForm=class(TCustomForm)
 { we have to set Forms fields like Form1.Button1, so we need to publish them with $M+
   I don't know if it change anything to set $M on at this top level instead of a lower level like
   TPersistent, but I don't need it anywhere else...
 }
 end;
{$M-}

 TApplication=class(TComponent)
 private
  fMainForm:TCustomForm;
  fTerminated:boolean;
 public
  Destructor Destroy; override;
  Procedure Initialize;
  Procedure CreateForm(InstanceClass: TComponentClass; var Reference);
  Procedure Run;
  Procedure ProcessMessages;
  Procedure Terminate;
 end;

Var
 Application:TApplication;

Implementation

Constructor TCustomForm.Create(AOwner:TComponent);
 begin
  inherited;
 {$ifdef clx}
  fHorzScrollBar:=TScrollBar.Create(Self);
  fVertScrollBar:=TScrollBar.Create(Self);
 {$endif}
  fBorderStyle := bsSizeable;
//  Load;
 end;

Destructor TCustomForm.Destroy;
 begin
 {$ifdef clx}
  fHorzScrollBar.Free;
  fVertScrollBar.Free;
 {$endif}
  DestroyWindow(fHandle);
  inherited;
 end;

Procedure TCustomForm.Load;
 const
  FilerSignature: array[1..4] of Char = 'TPF0';
 var
  Reader:TReader;
 begin
  Reader:=TReader.Create(ClassName);
  try
   if Reader.ReadInteger=Integer(FilerSignature) then Read(Reader);
  finally
   Reader.Free;
  end;
 end;

Procedure TCustomForm.Read(Reader:TReader);
 var
  Flags:TFilerFlags;
  Child:integer;
  sClass,sName:string;
 begin
  Reader.ReadPrefix(Flags,Child);
  sClass:=Reader.ReadString;
  sName :=Reader.ReadString;
  if not (ffInherited in Flags) then fName:=sName;
  ReadProperties(Reader);
  if Reader.Size-Reader.Position<>0 then
   MessageBox(fHandle,PChar(IntToStr(Reader.Size-Reader.Position)+' octet(s) en ressource'),PChar(sName+':'+sClass),0);
 end;

{$ifdef clx}
Function TCustomForm.SubProperty(Name:string):TPersistent;
 Const
  TCustomFormSubProperties:array[0..1] of PChar=(
   'HorzScrollBar',
   'VertScrollBar'
  );
 begin
  case StringIndex(Name,TCustomFormSubProperties) of
   0 : Result:=fHorzScrollBar;
   1 : Result:=fVertScrollBar;
   else Result:=Inherited SubProperty(Name);
  end;
 end;
{$endif}

procedure TCustomForm.ReadProperty(Name:string; Reader:TReader);
  Const
   TCustomFormProperties:array[0..5] of PChar=(
    'PixelsPerInch','TextHeight',
    'OldCreateOrder',
    'ClientWidth','ClientHeight',
    'BorderStyle'
   );
 begin
  case StringIndex(Name,TCustomFormProperties) of
    0 : fPixelsPerInch:=Reader.IntegerProperty;
    1 : fTextHeight:=Reader.IntegerProperty;
    2 : fOldCreateOrder:=Reader.BooleanProperty;
    3 : fWidth:=Reader.IntegerProperty+4;
    4 : fHeight:=Reader.IntegerProperty+12;
    5 : Reader.IdentProperty(fBorderStyle,['bsNone', 'bsSingle', 'bsSizeable', 'bsDialog', 'bsToolWindow', 'bsSizeToolWin']);
   else inherited;
  end;
end;

Procedure TCustomForm.CreateHandle;
 var
  style,exstyle:integer;
  // (bsNone, bsSingle, bsSizeable, bsDialog, bsToolWindow, bsSizeToolWin);
 begin
  case fBorderStyle of
   bsNone    : Style:=WS_POPUP;
   bsSingle  : Style:=WS_CAPTION or WS_BORDER or WS_SYSMENU;
   bsSizeable: Style:=WS_OVERLAPPEDWINDOW;
   bsDialog  : Style:=WS_DLGFRAME or WS_SYSMENU;
   else        Style:=0;
  end;
  case fBorderStyle of
   bsDialog      : exstyle:=WS_EX_DLGMODALFRAME or WS_EX_WINDOWEDGE;
   bsToolWindow  ,
   bsSizeToolWin : ExStyle:=WS_EX_TOOLWINDOW;
   else            exstyle:=0;
  end;
  Style:=style or WS_CLIPCHILDREN or WS_CLIPSIBLINGS;
//  style:=WS_OVERLAPPEDWINDOW;
// WS_OVERLAPPED, WS_CAPTION, WS_SYSMENU, WS_THICKFRAME, WS_MINIMIZEBOX, and WS_MAXIMIZEBOX
  Handle:=CreateWindowEx(
   exstyle,
   'LFORM',
   PChar(fCaption),
   style,
   fLeft,fTop,fWidth,fHeight,
   0,0,
   hInstance,
   nil
  );
 end;

Destructor TApplication.Destroy;
 begin
  UnregisterClass('LFORM',hInstance);
  inherited;
 end;

Procedure TApplication.Initialize;
 var
  WndClass:TWndClass;
 begin
  fTerminated:=False;
  FillChar(WndClass,SizeOf(WndClass),0);
  WndClass.hInstance:=hInstance; // hInstance in System (D2) or SysInit (D5) :(
  with WndClass do begin
   Style:=CS_VREDRAW or CS_HREDRAW;
   lpfnWndProc:=@DefWindowProc;
   hIcon:=LoadIcon(hInstance,'MAINICON');
   hCursor:=LoadCursor(0, IDC_ARROW);
   hbrBackground:=0; // GetStockObject(LTGRAY_BRUSH); --> WM_ERASBKGND
   lpszClassName:='LFORM';
  end;
  RegisterClass(WndClass);
 end;

procedure TApplication.CreateForm(InstanceClass: TComponentClass; var Reference);
var
  Instance: TComponent;
begin
  Instance := TComponent(InstanceClass.NewInstance);
  TComponent(Reference) := Instance;
  try
    Instance.Create(nil);//(Self);
    TCustomForm(Instance).Load;
  except
    TComponent(Reference) := nil;
    raise;
  end;
  if (FMainForm = nil) and (Instance is TCustomForm) then begin
//   TCustomForm(Instance).HandleNeeded;
   fMainForm:=TCustomForm(Instance);
  end;
end;

Procedure TApplication.Run;
 begin
  if fMainForm=nil then exit;
  fMainForm.Show;
  Repeat
   ProcessMessages;
  Until fTerminated;
 end;

Procedure TApplication.ProcessMessages;
 var
  msg:TMsg;
 begin
{$ifdef linux}
  XNextEvent(gDisplay,@msg);
  DispatchMessage(msg);
{$else}
  while PeekMessage(msg,0,0,0, PM_REMOVE) do begin
   if Msg.Message=WM_QUIT then
    fTerminated:=True
   else begin
    TranslateMessage(Msg);
    DispatchMessage(Msg);
   end;
  end;
{$endif}
 end;

Procedure TApplication.Terminate;
 begin
  fTerminated:=True;
 end;

Initialization
 Application:=TApplication.Create(nil);
Finalization
 Application.Free;

end.