Unit StdCtrls;

Interface

uses
 Windows,Messages,Classes,Controls,SysUtils,Graphics;

Type
 TLabel=class(TGraphicControl)
 public
  procedure paint; override;
 end;

 TButton=class(TWinControl)
 private
 {$ifdef linux}
  procedure paint; override;
 {$endif}
 protected
  procedure CreateHandle; override;
 public
  Constructor Create(AOwner:TComponent); override;
 end;

 TEdit=class(TWinControl)
 private
  fText:string;
 {$ifdef linux}
  procedure paint; override;
 {$endif}
 protected
  procedure CreateHandle; override;
 {$ifdef win32}
  function GetText:string;
 {$endif}
  procedure SetText(Value:string); override;
 public
 {$ifdef linux}
  property Text:string read fText write SetText;
 {$endif}
 {$ifdef win32}
  property Text:string read GetText write SetText;
 {$endif}
 end;

 TScrollBar=class(TWinControl)
 end;

Implementation

Procedure TLabel.Paint;
 begin
  with Canvas do begin
   Font.Assign(Self.Font);
   if fTransparent then Brush.Style:=bsClear else Brush.Color:=Color;
   TextOut(0,0,fCaption);
  end;
 end;

Constructor TButton.Create(AOwner:TComponent);
 begin
  inherited;
 {$ifdef win32}
  fTransparent:=True; // do not use color
 {$endif}
 {$ifdef linux}
  fControlStyle:=fControlStyle+[csClickEvents];
 {$endif}
 end;

procedure TButton.CreateHandle;
 begin
  Handle:=CreateWindow(
   'BUTTON',
   PChar(fCaption),
   WS_CHILD or WS_CLIPCHILDREN	or WS_TABSTOP,
   fLeft,fTop,fWidth,fHeight,
   Parent.Handle,
   0,
   hInstance,
   nil
  );
 end;

{$ifdef linux}
procedure TButton.Paint;
 var
  R:TRect;
 begin
  with Canvas do begin
   R:=Rect(0,0,fWidth-1,fHeight-1);
   if (csClicked in fControlState) then begin
    FrameRect(r,clBlack,clWhite);
    FrameRect(r,clGray,clSilver);
   end else begin
    FrameRect(R,clWhite,clBlack);
    FrameRect(R,clSilver,clGray);
   end;
   Brush.Color:=Color;
   FillRect(R);
   Pen.Color:=clBlack;
   TextOut(
    (fWidth-TextWidth(fCaption)) div 2,
    (fHeight-TextHeight(fCaption)) div 2,
    fCaption
   );
  end;
 end;
{$endif}

procedure TEdit.CreateHandle;
 begin
  Handle:=CreateWindowEx(
   WS_EX_CONTROLPARENT	or WS_EX_CLIENTEDGE,
   'EDIT',
   PChar(fCaption),
   WS_CHILD or WS_CLIPCHILDREN	or WS_TABSTOP,
   fLeft,fTop,fWidth,fHeight,
   Parent.Handle,
   0,
   hInstance,
   nil
  );
  SendMessage(Handle,WM_SETTEXT,0,integer(PChar(fText)));
 end;

{$ifdef win32}
Function TEdit.GetText:string;
 begin
  SetLength(Result,SendMessage(fHandle,WM_GETTEXTLENGTH,0,0));
  SetLength(Result,SendMessage(fHandle,WM_GETTEXT,Length(Result),integer(@Result[1])));
 end;
{$endif}

Procedure TEdit.SetText(Value:string);
 begin
  fText:=Value;
 {$ifdef win32}
  if fHandle<>0 then SendMessage(Handle,WM_SETTEXT,0,integer(PChar(Value)));
 {$endif}
 end;

{$ifdef linux}
procedure TEdit.Paint;
 var
  R:TRect;
 begin
  with Canvas do begin
   Brush.Color:=clWhite;
   R:=Rect(0,0,fWidth-1,fHeight-1);
   FillRect(r);
   FrameRect(r,clGray,clWhite);
   FrameRect(r,clBlack,clSilver);
   Pen.Color:=clBlack;
   TextOut(
    4,
    (fHeight-TextHeight(fCaption)) div 2,
    fText
   );
  end;
 end;
{$endif}

initialization
 RegisterClasses([TLabel,TButton,TEdit]);

end.
