Unit SysUtils;

Interface

Uses
 Windows;

Type
 TMethod = record
  Code, Data: Pointer;
 end;

Const
  clBlack = $000000;
  clMaroon = $000080;
  clGreen = $008000;
  clOlive = $008080;
  clNavy = $800000;
  clPurple = $800080;
  clTeal = $808000;
  clGray = $808080;
  clSilver = $C0C0C0;
  clRed = $0000FF;
  clLime = $00FF00;
  clYellow = $00FFFF;
  clBlue = $FF0000;
  clFuchsia = $FF00FF;
  clAqua = $FFFF00;
  clLtGray = $C0C0C0;
  clDkGray = $808080;
  clWhite = $FFFFFF;
  clNone = $1FFFFFFF;
  clDefault = $20000000;
{$ifdef linux}
  COLOR_SCROLLBAR = clSilver;
  COLOR_Background = clGray;
  COLOR_ActiveCaption = clBlue;
  COLOR_InactiveCaption = clGray;
  COLOR_Menu = clSilver;
  COLOR_Window = clWhite;
  COLOR_WindowFrame = clSilver;
  COLOR_MenuText = clBlack;
  COLOR_WindowText = clBlack;
  COLOR_CaptionText = clBlack;
  COLOR_ActiveBorder = clBlack;
  COLOR_InactiveBorder = clGray;
  COLOR_AppWorkSpace = clGray;
  COLOR_Highlight = clBlue;
  COLOR_HighlightText = clWhite;
  COLOR_BtnFace = clSilver;
  COLOR_BtnShadow = clGray;
  COLOR_GrayText = clGray;
  COLOR_BtnText = clBlack;
  COLOR_InactiveCaptionText = clBlack;
  COLOR_BtnHighlight = clWhite;
  COLOR_3DDkShadow = clGray;
  COLOR_3DLight = clWhite;
  COLOR_InfoText = clBlack;
  COLOR_InfoBk = clYellow;
{$endif}
  clScrollBar = COLOR_SCROLLBAR or $80000000;
  clBackground = COLOR_BACKGROUND or $80000000;
  clActiveCaption = COLOR_ACTIVECAPTION or $80000000;
  clInactiveCaption = COLOR_INACTIVECAPTION or $80000000;
  clMenu = COLOR_MENU or $80000000;
  clWindow = COLOR_WINDOW or $80000000;
  clWindowFrame = COLOR_WINDOWFRAME or $80000000;
  clMenuText = COLOR_MENUTEXT or $80000000;
  clWindowText = COLOR_WINDOWTEXT or $80000000;
  clCaptionText = COLOR_CAPTIONTEXT or $80000000;
  clActiveBorder = COLOR_ACTIVEBORDER or $80000000;
  clInactiveBorder = COLOR_INACTIVEBORDER or $80000000;
  clAppWorkSpace = COLOR_APPWORKSPACE or $80000000;
  clHighlight = COLOR_HIGHLIGHT or $80000000;
  clHighlightText = COLOR_HIGHLIGHTTEXT or $80000000;
  clBtnFace = COLOR_BTNFACE or $80000000;
  clBtnShadow = COLOR_BTNSHADOW or $80000000;
  clGrayText = COLOR_GRAYTEXT or $80000000;
  clBtnText = COLOR_BTNTEXT or $80000000;
  clInactiveCaptionText = COLOR_INACTIVECAPTIONTEXT or $80000000;
  clBtnHighlight = COLOR_BTNHIGHLIGHT or $80000000;
  cl3DDkShadow = COLOR_3DDKSHADOW or $80000000;
  cl3DLight = COLOR_3DLIGHT or $80000000;
  clInfoText = COLOR_INFOTEXT or $80000000;
  clInfoBk = COLOR_INFOBK or $80000000;

Procedure Error(Msg:string);
Procedure MsgBox(Msg:string);

Function IntToStr(i:integer):string;

Function Rect(Left,Top,Width,Height:integer):TRect;

Function StringIndex(s:string; p:Array of PChar):integer;

Function IdentToColor(s:string):integer;

Function IntToHex(i,p:integer):string;

function StrLen(const Str: PChar): Cardinal; assembler;
function ExtractFilePath(s:string):string;

// Borland's code
const
{ File open modes }
  fmOpenRead       = $0000;
  fmOpenWrite      = $0001;
  fmOpenReadWrite  = $0002;
  fmShareCompat    = $0000;
  fmShareExclusive = $0010;
  fmShareDenyWrite = $0020;
  fmShareDenyRead  = $0030;
  fmShareDenyNone  = $0040;

function FileCreate(const FileName: string): Integer;
function FileOpen(const FileName: string; Mode: LongWord): Integer;
procedure FileClose(Handle: Integer);
function FileSeek(Handle, Offset, Origin: Integer): Integer;
function FileRead(Handle: Integer; var Buffer; Count: LongWord): Integer;
function FileWrite(Handle: Integer; var Buffer; Count: LongWord): Integer;

function CreateDir(const Dir: string): Boolean;

Implementation

Procedure Error(Msg:string);
 begin
  MessageBox(0,PChar(Msg),'Error !',0);
 end;

Procedure MsgBox(Msg:string);
 begin
  MessageBox(0,PChar(Msg),'MySoft.Forms',0);
 end;

Function IntToStr(i:integer):string;
 begin
  Str(i,Result);
 end;

Function Rect(Left,Top,Width,Height:integer):TRect;
 begin
  Result.Left  :=Left;
  Result.Top   :=Top;
  Result.Right :=Left+Width;
  Result.Bottom:=Top+Height;
 end;

Function StringIndex(s:string; p:Array of PChar):integer;
 begin
  Result:=High(p);
  while (Result>=0)and(p[Result]<>s) do dec(Result);
 end;


{ Color mapping routines }
type
  TIdentMapEntry = record
    Value: longword;
    Name: String;
  end;

const
  Colors: array[0..41] of TIdentMapEntry = (
    (Value: clBlack; Name: 'clBlack'),
    (Value: clMaroon; Name: 'clMaroon'),
    (Value: clGreen; Name: 'clGreen'),
    (Value: clOlive; Name: 'clOlive'),
    (Value: clNavy; Name: 'clNavy'),
    (Value: clPurple; Name: 'clPurple'),
    (Value: clTeal; Name: 'clTeal'),
    (Value: clGray; Name: 'clGray'),
    (Value: clSilver; Name: 'clSilver'),
    (Value: clRed; Name: 'clRed'),
    (Value: clLime; Name: 'clLime'),
    (Value: clYellow; Name: 'clYellow'),
    (Value: clBlue; Name: 'clBlue'),
    (Value: clFuchsia; Name: 'clFuchsia'),
    (Value: clAqua; Name: 'clAqua'),
    (Value: clWhite; Name: 'clWhite'),
    (Value: clScrollBar; Name: 'clScrollBar'),
    (Value: clBackground; Name: 'clBackground'),
    (Value: clActiveCaption; Name: 'clActiveCaption'),
    (Value: clInactiveCaption; Name: 'clInactiveCaption'),
    (Value: clMenu; Name: 'clMenu'),
    (Value: clWindow; Name: 'clWindow'),
    (Value: clWindowFrame; Name: 'clWindowFrame'),
    (Value: clMenuText; Name: 'clMenuText'),
    (Value: clWindowText; Name: 'clWindowText'),
    (Value: clCaptionText; Name: 'clCaptionText'),
    (Value: clActiveBorder; Name: 'clActiveBorder'),
    (Value: clInactiveBorder; Name: 'clInactiveBorder'),
    (Value: clAppWorkSpace; Name: 'clAppWorkSpace'),
    (Value: clHighlight; Name: 'clHighlight'),
    (Value: clHighlightText; Name: 'clHighlightText'),
    (Value: clBtnFace; Name: 'clBtnFace'),
    (Value: clBtnShadow; Name: 'clBtnShadow'),
    (Value: clGrayText; Name: 'clGrayText'),
    (Value: clBtnText; Name: 'clBtnText'),
    (Value: clInactiveCaptionText; Name: 'clInactiveCaptionText'),
    (Value: clBtnHighlight; Name: 'clBtnHighlight'),
    (Value: cl3DDkShadow; Name: 'cl3DDkShadow'),
    (Value: cl3DLight; Name: 'cl3DLight'),
    (Value: clInfoText; Name: 'clInfoText'),
    (Value: clInfoBk; Name: 'clInfoBk'),
    (Value: clNone; Name: 'clNone'));

Function IdentValue(s:string; values:array of TIdentMapEntry):integer;
 begin
  Result:=High(values);
  while (Result>0)and(values[Result].Name<>s) do dec(Result);
  Result:=values[Result].Value;
 end;

Function IdentToColor(s:string):integer;
 begin
  result:=IdentValue(s,Colors);
  if Result<0 then Result:=GetSysColor(Result and $FF);
 end;

Function IntToHex(i,p:integer):string;
 const
  Hexa:array[0..$F] of char='0123456789ABCDEF';
 begin
  result:='';
  while (p>0)or(i>0) do begin
   dec(p,2);
   result:=hexa[(i shr 4) and $F]+hexa[i and $F]+result;
   i:=i shr 8;
  end;
 end;

function StrLen(const Str: PChar): Cardinal;
 begin
  Result:=0;
  if Str<>nil then While Str[Result]<>#0 do inc(Result);
 end;

function ExtractFilePath(s:string):string;
 var
  p1,p2:integer;
 begin
  p1:=pos('\',s);
  if p1=0 then begin
   p1:=pos(':',s);
   if p1=0 then result:='' else result:=copy(s,1,p1);
  end else begin
   p2:=pos('\',copy(s,p1+1,length(s)));
   while p2>0 do begin
    inc(p1,p2);
    p2:=pos('\',copy(s,p1+1,length(s)));
   end;
   result:=copy(s,1,p1);
  end;
 end;

function FileCreate(const FileName: string): Integer;
begin
  Result := Integer(CreateFile(PChar(FileName), GENERIC_READ or GENERIC_WRITE,
    0, nil, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0));
end;
 
function FileOpen(const FileName: string; Mode: LongWord): Integer;
const
  AccessMode: array[0..2] of LongWord = (
    GENERIC_READ,
    GENERIC_WRITE,
    GENERIC_READ or GENERIC_WRITE);
  ShareMode: array[0..4] of LongWord = (
    0,
    0,
    FILE_SHARE_READ,
    FILE_SHARE_WRITE,
    FILE_SHARE_READ or FILE_SHARE_WRITE);
begin
  Result := Integer(CreateFile(PChar(FileName), AccessMode[Mode and 3],
    ShareMode[(Mode and $F0) shr 4], nil, OPEN_EXISTING,
    FILE_ATTRIBUTE_NORMAL, 0));
end;

procedure FileClose(Handle: Integer);
begin
  CloseHandle(THandle(Handle));
end;

function FileSeek(Handle, Offset, Origin: Integer): Integer;
begin
  Result := SetFilePointer(THandle(Handle), Offset, nil, Origin);
end;

function FileRead(Handle: Integer; var Buffer; Count: LongWord): Integer;
begin
  if not ReadFile(THandle(Handle), Buffer, Count, LongWord(Result), nil) then
    Result := -1;
end;

function FileWrite(Handle: Integer; var Buffer; Count: LongWord): Integer;
begin
  if not WriteFile(THandle(Handle), Buffer, Count, LongWord(Result), nil) then
    Result := -1;
end;

function CreateDir(const Dir: string): Boolean;
begin
  Result := CreateDirectory(PChar(Dir), nil);
end;

end.
