Unit Windows; // Linux version of Windows unit

Interface

Uses
 Xlib,Messages;

Const
 RT_RCDATA = PChar(10);
 GWL_WNDPROC = 1;

 WS_CHILD           =1;
 WS_CLIPCHILDREN    =2;
 WS_TABSTOP         =4;
 WS_VISIBLE         =8;
 WS_OVERLAPPEDWINDOW=16;

 WS_EX_CONTROLPARENT =1;
 WS_EX_CLIENTEDGE    =2;

 CS_VREDRAW=1;
 CS_HREDRAW=2;

 SW_SHOW = 1;

 FW_NORMAL=0;
 FW_BOLD  =1;
 DEFAULT_CHARSET=0;
 DEFAULT_QUALITY=0;
 OUT_DEFAULT_PRECIS=0;
 CLIP_DEFAULT_PRECIS=0;
 DEFAULT_PITCH=0;

 IDC_ARROW=PChar(1);

 PM_REMOVE=1;

Type
 TRect=record
  Left,Top,Right,Bottom:integer;
 end;

 TLogFont=packed record
  lfHeight:integer;
  lfWidth :integer;
  lfEscapement :integer;
  lfOrientation:integer;
  lfWeight :integer;
  lfItalic :byte;
  lfUnderline :byte;
  lfStrikeOut :byte;
  lfCharSet :byte;
  lfOutPrecision :byte;
  lfClipPrecision:byte;
  lfQuality :byte;
  lfPitchAndFamily:byte;
  lfFaceName:array[0..31] of char;
 end;

 TWndClass=packed record
  Style:integer;
  lpfnWndProc:pointer;
  cbClsExtra:integer;
  cbWndExtra:integer;
  hInstance:integer;
  hIcon:integer;
  hCursor:integer;
  hbrBackground:integer;
  lpszMenuName:PChar;
  lpszClassName:PChar;
 end;

 TPoint=record
  x,y:integer;
 end;
{
 TMsg=packed record
  hWnd:integer;
  Message:integer;
  wParam:integer;
  lParam:integer;
  Time:integer;
  pt:TPoint;
 end;
}
 TMsg=XEvent;

procedure MessageBox(HWnd:integer; Msg,Caption:PChar; Flags:integer);
Function GetSysColor(Color:integer):integer;
procedure DeleteObject(Handle:integer);
Function CreateFontIndirect(Var LogFont:TLogFont):integer;
Procedure SetProp(Handle:integer; Name:PChar; Value:integer);
Function GetProp(Handle:integer; Name:PChar):integer;
Function DefWindowProc(Hwnd,Msg,wParam,lParam:integer):integer;
Function CallWindowProc(Proc:pointer;Hwnd,Msg,wParam,lParam:integer):integer;
Procedure SetWindowLong(HWnd,Index,Value:integer);
Function GetWindowLong(Hwnd,Index:integer):integer;
Function CreateSolidBrush(Color:integer):integer;
Procedure FillRect(dc:Integer;const R:TRect; color:integer);
Procedure PostQuitMessage(ExitCode:integer);
Procedure CloseHandle(Handle:integer);

Function CreateWindow(ClassName,Caption:PChar; Style,Left,Top,Width,Height,Parent,Menu,Instance:integer; data:pointer):integer;
Function CreateWindowEx(ExStyle:integer; ClassName,Caption:PChar; Style,Left,Top,Width,Height,Parent,Menu,Instance:integer; data:pointer):integer;
Function SendMessage(HWnd,Msg,wParam,lParam:integer):integer;
Procedure ShowWindow(HWnd,CmdShow:integer);
Function DestroyWindow(Hwnd:integer):integer;

Function PeekMessage(Var Msg:TMsg; hWnd,Min,Max,Remove:integer):boolean;
Procedure TranslateMessage(Var Msg:TMsg);
Procedure DispatchMessage(Var Msg:TMsg);

Function LoadIcon(Instance:integer; Name:PChar):integer;
Function LoadCursor(Instance:integer; Name:PChar):integer;

Procedure RegisterClass(const WndClass:TWndClass);
Function UnregisterClass(ClassName:PChar; Instance:integer):integer;

var
 gDisplay :PDisplay;
 gScreen  :integer;
 gGC      :TGC;
 gRootWin :Window;
 gColorMap:ColorMap;
 gBlack   :integer;
 gWhite   :integer;
 gDepth   :integer;
 gVisual  :PVisual;
 gFont    :PXFontStruct;

procedure XDrawImageString(Display: PDisplay; D: TDrawable; GC: TGC;
  X, Y: Integer; S: PChar; Len: Integer); cdecl; 

Implementation

Uses
 Forms,SysUtils;

{ Kylix fix # }
procedure XChangeProperty(Display: PDisplay; W: TWindow;
   AProperty, AType: TAtom; Format, Mode: Longint; Data: PByte; NElements: Longint);
   cdecl;                  {^fix^}
external 'libX11.so.6' name 'XChangeProperty';

{ Kylix fix # }

procedure XDrawImageString(Display: PDisplay; D: TDrawable; GC: TGC;

  X, Y: Integer; S: PChar; Len: Integer); cdecl;

external 'libX11.so.6' name 'XDrawImageString';


procedure MessageBox(HWnd:integer; Msg,Caption:PChar; Flags:integer);
 begin
  writeln('[',Caption,'] ',Msg);
 end;

Function GetSysColor(Color:integer):integer;
 var
  cl:XColor;
 begin
  cl.pixel:=0;
  cl.red  :=(Color and $0000FF) shl 8;
  cl.green:=(Color and $00FF00);
  cl.blue :=(Color and $FF0000) shr 8;
  XAllocColor(gDisplay,gColorMap,@cl);
  Result:=cl.pixel;
 end;

procedure DeleteObject(Handle:integer);
 begin
  TObject(Handle).Free;
 end;

function CreateFontIndirect(Var LogFont:TLogFont):integer;
 begin
  Result:=0;
 end;

Procedure SetProp(Handle:integer; Name:PChar; Value:integer);
 begin
  XChangeProperty(
   gDisplay,Handle,
   XInternAtom(gDisplay,Name,bool(False)), // String2Atom (even if not exist)
   XA_INTEGER,32,PropModeAppend,PByte(@Value),1
  );
 end;

Function GetProp(Handle:integer; Name:PChar):integer;
 var
  atype:TAtom; aformat,acount,aleft:integer;
  value:^integer;
 begin
  XGetWindowProperty(
   gDisplay,Handle,
   XInternAtom(gDisplay,Name,bool(True)), // String2Atom (only if exist)
   0 { offset in prop }, SizeOf(Result) div 4 { length },
   bool(False), { do not deleted }
   AnyPropertyType, { property type }
   @AType,@AFormat,@ACount,@ALeft, { found Type, Format, Count & Bytes Left }
   @Value
  );
  Result:=value^;
  XFree(Value);
 end;

Function DefWindowProc(Hwnd,Msg,wParam,lParam:integer):integer;
 begin
  Result:=0;
 end;

Function CallWindowProc(Proc:pointer;Hwnd,Msg,wParam,lParam:integer):integer;
 begin
  Result:=0;
 end;

Procedure SetWindowLong(HWnd,Index,Value:integer);
 begin
 end;

Function GetWindowLong(Hwnd,Index:integer):integer;
 begin
  Result:=0;
 end;

Function CreateSolidBrush(Color:integer):integer;
 begin
  Result:=Color;
 end;

Procedure FillRect(dc:Integer;const R:TRect; color:integer);
 begin
 end;

Procedure PostQuitMessage(ExitCode:integer);
 begin
  Halt(ExitCode);
 end;

Procedure CloseHandle(Handle:integer);
 begin
  TObject(Handle).Free;
 end;

Function CreateWindow(ClassName,Caption:PChar; Style,Left,Top,Width,Height,Parent,Menu,Instance:integer; data:pointer):integer;
 begin
  Result:=CreateWindowEx(0,ClassName,Caption,Style,Left,Top,Width,Height,Parent,Menu,Instance,data);
 end;

Function CreateWindowEx(ExStyle:integer; ClassName,Caption:PChar; Style,Left,Top,Width,Height,Parent,Menu,Instance:integer; data:pointer):integer;
{$define simple}
{$ifndef simple}
 var
  XAttr:XSetWindowAttributes;
{$endif}
 begin
 if Parent=0 then Parent:=gRootWin;
 {$ifdef simple}
  Result:=XCreateSimpleWindow(
   gDisplay,
   Parent,
   Left,Top,Width,Height,0,
   gBlack,
   gWhite//GetSysColor(fColor)
  );
  XSelectInput(gDisplay,Result,ExposureMask or ButtonPressMask or ButtonReleaseMask or PointerMotionMask);
 {$else}
  XAttr.event_mask:=ExposureMask or ButtonPressMask or ButtonReleaseMask or PointerMotionMask;
  XAttr.background_pixel:=gWhite;//GetSysColor(fColor);
  XAttr.border_pixel:=gBlack;
  Result:=XCreateWindow(
   gDisplay,
   Parent,
   Left,Top,Width,Height, 0,
   gDepth,
   InputOutput,
   gVisual,
   CWEventMask or CWBackPixel or CWBorderPixel,
   @XAttr
  );
 {$endif}
  XChangeProperty(gDisplay,Result,XA_WM_NAME,XA_STRING,8,PropModeReplace,PByte(Caption),StrLen(Caption));
 end;

Function SendMessage(HWnd,Msg,wParam,lParam:integer):integer;
 begin
  Result:=0;
 end;

Procedure ShowWindow(HWnd,CmdShow:integer);
 begin
 // we suppose that CmdShow=SW_SHOW
  XMapWindow(gDisplay,Hwnd);
 end;

Function DestroyWindow(Hwnd:integer):integer;
 begin
  CloseHandle(Hwnd);
  Result:=0;
 end;

Function PeekMessage(Var Msg:TMsg; hWnd,Min,Max,Remove:integer):boolean;
 begin
  Result:=XPeekEvent(gDisplay,@Msg)=0;
//  Result:=(Msg.Message<>WM_QUIT);
//  Msg.Message:=WM_QUIT;
 end;

Procedure TranslateMessage(Var Msg:TMsg);
 begin
 end;

Procedure DispatchMessage(Var Msg:TMsg);
 var
  obj:TObject;
 begin
  obj:=TObject(GetProp(Msg.xany.xwindow,'MySoft.LightVCL'));
  if obj<>nil then obj.Dispatch(Msg);
 end;

Function LoadIcon(Instance:integer; Name:PChar):integer;
 begin
  Result:=0;
 end;

Function LoadCursor(Instance:integer; Name:PChar):integer;
 begin
  Result:=0;
 end;

Procedure RegisterClass(const WndClass:TWndClass);
 begin
 end;

Function UnregisterClass(ClassName:PChar; Instance:integer):integer;
 begin
  Result:=0;
 end;

initialization
 gDisplay:=XOpenDisplay(nil);
 if gDisplay=nil then begin
  WriteLn('Unable to open Display');
  halt;
 end;
 gScreen:=XDefaultScreen(gDisplay);
 gGC:=XDefaultGC(gDisplay,gScreen);
 gRootWin:=XRootWindow(gDisplay,gScreen);
 gColorMap:=XDefaultColormap(gDisplay,gScreen);
 gBlack:=XBlackPixel(gDisplay,gScreen);
 gWhite:=XWhitePixel(gDisplay,gScreen);
 gDepth:=XDefaultDepth(gDisplay,gScreen);
 gVisual:=XDefaultVisual(gDisplay,gScreen);
 gFont:=XQueryFont(gDisplay,XGContextFromGC(gGC));


finalization
 XCloseDisplay(gDisplay);

end.
